define([
    'App',
    'marionette',
    'underscore',
    'modules/appointments/appointments-radio',
    'modules/appointments/list-section/appointments-list-item-view',
    'text!modules/appointments/booked/booked-appointments-list-item.html',
    'modules/appointments/list-section/appointments-list-view',
    'text!modules/appointments/booked/booked-appointments-list.html',
],
function (
    app,
    Marionette,
    _,
    radio,
    AppointmentsListItemView,
    childViewTemplate,
    AppointmentsListView,
    template
) {
    'use strict';

    // item view
    var ItemView = AppointmentsListItemView.extend({
        template: childViewTemplate,
        // on 'click button': 'showDetails'
        showDetails: function() {
            radio.trigger('appointments:appointment:selected', this.model);
        },

        templateContext: function () {
            var timeZone = this.model.has('timeZone') ? this.model.get('timeZone') : '';
            var maxStr = 3;
            return {
                ccIsDisabled: !_.isUndefined(app.disabledFeatures.get('CC_FEATURE_SET')),
                timeZone: timeZone.substring(timeZone.length - maxStr, timeZone.length),
            };
        },
    });
    // composite view
    return AppointmentsListView.extend({
        template: template,
        childView: ItemView,
        collectionEvents: {
            'sync': 'render',
            'reset': 'render',
        },
        templateContext: function () {
            return {
                ccIsDisabled: !_.isUndefined(app.disabledFeatures.get('CC_FEATURE_SET')),
            };
        },
    });
});
